#!/bin/bash

#
# Copyright (C) 2000 karsten reincke <karsten.reincke@fodina.de>
# This file is part of of the software-project GTGT.
#
# GTGT is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#  
# file <change-release> version <#3.1.0#> of project <GTGT>


# change the following 6 variables with respect to this pattern
# version-number is RELEASE.REVISION.STEP

OLDRELEASE=3    	# defines a release and a library interface
OLDREVISION=0   	# defines a more important revision of a release
OLDSTEP=0       	# defines a lowlevel revesion of a release
      	      	      	# (doesn't concern libraries
OLDLIBAGE=0   	      	# indicates how many of the elder
      	      	      	# library-releases offer the same interface 

NEWRELEASE=3
NEWREVISION=1
NEWSTEP=0
NEWLIBAGE=0   	      	

#---------------------------------------------------------------------------------
# change the following 6 variables only if you know the revision system of libtool
OLDLIBTOOLCURRENT="${OLDRELEASE}"
OLDLIBTOOLREVISION="${OLDREVISION}"
OLDLIBTOOLAGE="${OLDLIBAGE}"

NEWLIBTOOLCURRENT="${NEWRELEASE}"
NEWLIBTOOLREVISION="${NEWREVISION}"
NEWLIBTOOLAGE="${NEWLIBAGE}"

#################################################################################
# don't change the following lines !

OLDVERSION="${OLDRELEASE}\.${OLDREVISION}\.${OLDSTEP}"
OLDLIBVERSION="${OLDLIBTOOLCURRENT}\:${OLDLIBTOOLREVISION}\:${OLDLIBTOOLAGE}"

NEWVERSION="${NEWRELEASE}\.${NEWREVISION}\.${NEWSTEP}"
NEWLIBVERSION="${NEWLIBTOOLCURRENT}\:${NEWLIBTOOLREVISION}\:${NEWLIBTOOLAGE}"

if [ $# = 0 -o "$1" = "-h" -o "$1" = "--help" ]
then
  echo "script for changing recursively all revision- and branchnumbers"
  echo "usage:  change-release [ -h | --help | * | FILENAME ... ]"
  echo "for inserting old and new numbers please edit change-release"
  exit
fi

while [ ! -z $1 ];
do
  if [ -d $1 -o -L $1 ]
  then
    if [ -d $1 ]
    then
      cp change-release $1/change-release
      cd $1
      ./change-release *
      rm change-release
      cd ..
    else
      echo "ignoring link $1"
    fi
  else
    if [ -f $1 -a ! -L $1 ]
    then
      INFILE=${1}.xyz
      OUTFILE=${1}
      echo "setting $OLDVERSION onto $NEWVERSION in $OUTFILE"
      cp $OUTFILE $INFILE
      sed -e "/<#$OLDVERSION#>/s/$OLDVERSION/$NEWVERSION/" $INFILE > $OUTFILE
      rm $INFILE
    else
      echo "ignoring $1"
    fi
  fi
  shift
done

if [ -f configure.in ]
then
  echo "setting $OLDVERSION onto $NEWVERSION in configure.in"
  mv configure.in configure.org
  sed -e "/(gtgt,$OLDVERSION)/s/$OLDVERSION/$NEWVERSION/" configure.org > configure.in
  rm configure.org
fi

if [ -f Makefile.am ]
then
  echo "setting $OLDVERSION onto $NEWVERSION in libsection of ..."
  echo "... $PWD\Makefile.am"
  mv Makefile.am Makefile.org
  sed -e "/info $OLDLIBVERSION/s/$OLDLIBVERSION/$NEWLIBVERSION/" Makefile.org > Makefile.am  
  rm Makefile.org
fi

if [ -f Doxyfile ]
then
  echo "setting $OLDVERSION onto $NEWVERSION in Doxyfile"
  mv Doxyfile Doxyfile.org
  sed -e "/PROJECT_NUMBER = $OLDVERSION/s/$OLDVERSION/$NEWVERSION/" Doxyfile.org > Doxyfile 
  rm Doxyfile.org
fi

if [ -f prj.spec ]
then
  echo "setting $OLDVERSION onto $NEWVERSION in prj.spec"
  mv prj.spec prj.spec.org
  sed -e "/define PRJ_RELEASE $OLDVERSION/s/$OLDVERSION/$NEWVERSION/" prj.spec.org > prj.spec
  rm prj.spec.org
fi



